/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Implementation of the function entry/exit tracing class.
 *
 ***************************************************************************/

#include "Os.h"
#include "Misc.h"
#include "FuncTrace.hpp"
#if defined(EVENT_TRACING)
/*
 *  The trace message header (.tmh) file must be included in a source file
 *  before any WPP macro calls and after defining a WPP_CONTROL_GUIDS
 *  macro (defined in trace.h). During the compilation, WPP scans the source
 *  files for DoTraceMessage() calls and builds a .tmh file which stores a unique
 *  data GUID for each message, the text resource string for each message,
 *  and the data types of the variables passed in for each message.
 *  This file is automatically generated and used during post-processing.
 */
#include "FuncTrace.tmh"
#endif



/**
 *  Constructor.
 * @param Specifies function name.
 */
FuncTrace::FuncTrace(char const * pFuncName)
    : pFuncName_(pFuncName)
{
    PATH_TESTED();
    PRECONDITION(pFuncName_ != NULL);
    OsTrace(OS_LEVEL_VERBOSE,
            OS_TRACE_FLAG_FUNC_TRACE,
            "Entering %s\n",
            pFuncName_);
}


/**
 *  Destructor.
 */
FuncTrace::~FuncTrace()
{
    PATH_TESTED();
    PRECONDITION(pFuncName_ != NULL);
    OsTrace(OS_LEVEL_VERBOSE,
            OS_TRACE_FLAG_FUNC_TRACE,
            "Leaving %s\n",
            pFuncName_);
}
