/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    OS independant interrupt definitions.
 *
 ***************************************************************************/

#ifndef INC_Interrupt_h
#define INC_Interrupt_h


#include "OsInterrupt.h"



/**
 *  Acquire an interrupt spinlock.
 *  This function changes the IRQL. It must be paired with
 *  OsInterruptReleaseLock in order to restore it.
 * @param A handle to an interrupt object.
 */
void
OsInterruptAcquireLock(
    OsInterruptHandle hInterrupt);


/**
 *  Release an interrupt spinlock.
 *  This function changes the IRQL. It must be paired with
 *  OsInterruptAcquireLock in order to restore it.
 * @param A handle to an interrupt object.
 */
void
OsInterruptReleaseLock(
    OsInterruptHandle hInterrupt);



#include "OsInterrupt_inline.h"



#endif // INC_Interrupt_h
