/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    OS independant I/O control definitions.
 *
 ***************************************************************************/

#ifndef INC_Ioctl_h
#define INC_Ioctl_h


#include "OsIoctl.h"



/**
 *  Mark an I/O control request pending and cancellable.
 * @param A handle to the I/O control request object.
 * @param A callback function that cancels the I/O request.
 */
void
OsIoctlMarkPendingAndCancellable(
    OsIoctlHandle         hIoctl,
    OsIoctlCancelCallback pfIoctlCancel);


/**
 *  Complete an I/O control request not marked pending (i.e. cancellable).
 * @param A handle to the I/O control request object.
 * @param A completion status of the request.
 * @param The number of bytes transferred.
 */
void
OsIoctlComplete(
    OsIoctlHandle hIoctl,
    OsStatus      osStatus,
    size_t        bytesTransferred);


/**
 *  Complete a pending (i.e. cancellable) I/O control request.
 * @param A handle to the I/O control request object.
 * @param A completion status of the request.
 * @param The number of bytes transferred.
 */
void
OsIoctlCompletePending(
    OsIoctlHandle hIoctl,
    OsStatus      osStatus,
    size_t        bytesTransferred);


/**
 *  Cancel a pending (i.e. cancellable) I/O control request.
 * @param A handle to the I/O control request object.
 */
void
OsIoctlCancelPending(
    OsIoctlHandle hIoctl);



#include "OsIoctl_inline.h"



#endif // INC_Ioctl_h
