/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    OS independant memory definitions.
 *
 ***************************************************************************/

#ifndef INC_Memory_h
#define INC_Memory_h


#include "OsMemory.h"



/**
 *  Allocate a memory buffer.
 * @param Bytes to allocate.
 * @param Memory pool type.
 * @param Memory pool tag.
 * @return A memory buffer pointer on success or NULL otherwise.
 */
void *
OsMemoryBufferAllocate(
    size_t        size,
    OsMemoryType  type,
    OsMemoryTag   tag);


/**
 *  Free a memory buffer.
 * @param A memory object buffer pointer.
 */
void
OsMemoryBufferFree(
    void * pBuffer);



#include "OsMemory_inline.h"



#endif // INC_Memory_h
