/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Implementation of debug output functions.
 *
 ***************************************************************************/

#include <linux/module.h>
#include "DbgTrace.h"

MODULE_LICENSE("Dual BSD/GPL");


#if DBG


/**
 *  Global debug error level.
 *  Messages at this level or below are printed out.
 */
TraceDebugLevel   gDebugLevel = OS_LEVEL_VERBOSE;
/**
 *  Global debug flags.
 *  Messages from components specified in the flags are printed out.
 */
unsigned long             gDebugFlags = 0xFFFFFFFF;


/**
 *  Path tracing macros.
 */
#define PATH_TESTED_TRACE
#define PATH_NOT_YET_TESTED_TRACE       DbgPrint("%s: PNT %s/%u\n",     \
                                                 gDriverName,           \
                                                 __FILE__,              \
                                                 __LINE__)

/**
 *  Output a debug message.
 * @param Specifies the severity of the message being output.
 * @param Specifies the component calling this routine.
 * @param Specifies a pointer to the format string to print (printf style).
 * @param Specifies arguments for the format string.
 */
void
OsDebugOutput(
    TraceDebugLevel debugLevel,
    unsigned long   debugFlags,
    const char *    pMsgFormat,
    ...
    )
{
    if (/*(debugLevel <= gDebugLevel) && */(debugFlags & gDebugFlags))
    {
        va_list list;
        va_start(list, pMsgFormat);
        vprintk(pMsgFormat, list);
        va_end(list);
    }
}

/**
 *  Output a debug message.
 * @param Specifies the severity of the message being output.
 * @param Specifies the component calling this routine.
 * @param A boolean specifying whether to trace or not.
 * @param Specifies a pointer to the format string to print (printf style).
 * @param Specifies arguments for the format string.
 */
void
OsDebugOutputCond(
    TraceDebugLevel debugLevel,
    unsigned long   debugFlags,
    BOOLEAN         bCondition,
    const char *    pMsgFormat,
    ...
    )
{
    PATH_TESTED_TRACE;

    if (bCondition && (debugFlags & gDebugFlags))
    {
        va_list list;
        va_start(list, pMsgFormat);
        vprintk(pMsgFormat, list);
        va_end(list);
    }
}

#endif // DBG
