/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    OS dependant HW access inline functions.
 *
 ***************************************************************************/

#ifndef INC_OsHwAccess_inline_h
#define INC_OsHwAccess_inline_h


#include "OsHwAccess.h"



/**
 *  Read an 8-bit wide register.
 * @param A register base descriptor.
 * @param A register offset in bytes.
 * @return Value read from the register.
 */
OS_INLINE extern U08
OsRegisterRead08(
    OsRegBaseDescriptor const * const pRegBaseDescr,
    size_t                            offset)
{
    ASSERT(pRegBaseDescr != NULL);
    ASSERT(pRegBaseDescr->pfRead08 != NULL);
    return pRegBaseDescr->pfRead08(pRegBaseDescr, offset);
}


/**
 *  Read a 16-bit wide register.
 * @param A register base descriptor.
 * @param A register offset in bytes.
 * @return Value read from the register.
 */
OS_INLINE extern U16
OsRegisterRead16(
    OsRegBaseDescriptor const * const pRegBaseDescr,
    size_t                            offset)
{
    ASSERT(pRegBaseDescr != NULL);
    ASSERT(pRegBaseDescr->pfRead16 != NULL);
    return pRegBaseDescr->pfRead16(pRegBaseDescr, offset);
}


/**
 *  Read a 32-bit wide register.
 * @param A register base descriptor.
 * @param A register offset in bytes.
 * @return Value read from the register.
 */
OS_INLINE extern U32
OsRegisterRead32(
    OsRegBaseDescriptor const * const pRegBaseDescr,
    size_t                            offset)
{
    ASSERT(pRegBaseDescr != NULL);
    ASSERT(pRegBaseDescr->pfRead32 != NULL);
    return pRegBaseDescr->pfRead32(pRegBaseDescr, offset);
}


/**
 *  Write to an 8-bit wide register.
 * @param A register base descriptor.
 * @param A register offset in bytes.
 * @param A value to be written.
 */
OS_INLINE extern void
OsRegisterWrite08(
    OsRegBaseDescriptor const * const pRegBaseDescr,
    size_t                            offset,
    U08                               value)
{
    ASSERT(pRegBaseDescr != NULL);
    ASSERT(pRegBaseDescr->pfWrite08 != NULL);
    return pRegBaseDescr->pfWrite08(pRegBaseDescr, offset, value);
}


/**
 *  Write to a 16-bit wide register.
 * @param A register base descriptor.
 * @param A register offset in bytes.
 * @param A value to be written.
 */
OS_INLINE extern void
OsRegisterWrite16(
    OsRegBaseDescriptor const * const pRegBaseDescr,
    size_t                            offset,
    U16                               value)
{
    ASSERT(pRegBaseDescr != NULL);
    ASSERT(pRegBaseDescr->pfWrite16 != NULL);
    return pRegBaseDescr->pfWrite16(pRegBaseDescr, offset, value);
}


/**
 *  Write to a 32-bit wide register.
 * @param A register base descriptor.
 * @param A register offset in bytes.
 * @param A value to be written.
 */
OS_INLINE extern void
OsRegisterWrite32(
    OsRegBaseDescriptor const * const pRegBaseDescr,
    size_t                            offset,
    U32                               value)
{
    ASSERT(pRegBaseDescr != NULL);
    ASSERT(pRegBaseDescr->pfWrite32 != NULL);
    return pRegBaseDescr->pfWrite32(pRegBaseDescr, offset, value);
}


#endif // INC_OsHwAccess_inline_h
