/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    OS dependant I/O control inline functions.
 *
 ***************************************************************************/

#ifndef INC_OsIoctl_inline_h
#define INC_OsIoctl_inline_h


#include "OsIoctl.h"


OS_INLINE extern void
OsIoctlMarkPendingAndCancellable(
    OsIoctlHandle         hIoctl,
    OsIoctlCancelCallback pfIoctlCancel)
{
    PATH_TESTED();
    
    hIoctl->osStatus = OS_STATUS__PENDING;
}




/**
 *  Complete an I/O control request not marked as cancellable.
 * @param A handle to the I/O control request object.
 * @param A completion status of the request.
 * @param The number of bytes transferred.
 */
OS_INLINE extern void
OsIoctlComplete(
    OsIoctlHandle hIoctl,
    OsStatus      osStatus,
    size_t        bytesTransferred)
{
    PATH_TESTED();
 
    hIoctl->osStatus = osStatus;
}


/**
 *  Complete an I/O control request marked as pending.
 * @param A handle to the I/O control request object.
 * @param A completion status of the request.
 * @param The number of bytes transferred.
 */
OS_INLINE extern void
OsIoctlCompletePending(
    OsIoctlHandle hIoctl,
    OsStatus      osStatus,
    size_t        bytesTransferred)
{
    PATH_TESTED();
    
    hIoctl->osStatus = osStatus;

    // call unmark pending
    wake_up_interruptible(hIoctl->pWqIoctl);
}


/**
 *  Finish cancelling an I/O control request (must be marked as cancellable).
 * @param A handle to the I/O control request object.
 */
OS_INLINE extern void
OsIoctlCancelPending(
    OsIoctlHandle hIoctl)
{
    PATH_NOT_YET_TESTED();
    
    hIoctl->osStatus = OS_STATUS__CANCELLED;

    //call unmark pending
    wake_up_interruptible(hIoctl->pWqIoctl);
    
}


#endif // INC_OsIoctl_inline_h
