/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2007
 *
 *  Description:    Implementation of OS dependant spinlock functions.
 *
 ***************************************************************************/

#include "Misc.h"
#include "OsSpinLock.h"
#include "DbgTrace.h"
#if defined(EVENT_TRACING)
/*
 *  The trace message header (.tmh) file must be included in a source file
 *  before any WPP macro calls and after defining a WPP_CONTROL_GUIDS
 *  macro (defined in trace.h). During the compilation, WPP scans the source
 *  files for DoTraceMessage() calls and builds a .tmh file which stores a unique
 *  data GUID for each message, the text resource string for each message,
 *  and the data types of the variables passed in for each message.
 *  This file is automatically generated and used during post-processing.
 */
#include "OsSpinLock.tmh"
#endif



/**
 *  Create a spinlock.
 * @param The spinlock parent object handle.
 * @return A handle to the new spinlock object.
 */
OsSpinLockHandle
OsSpinLockConstruct(
    OsObjectHandle hParent)
{
    OsSpinLockHandle hLock = OS_INVALID_HANDLE; 
    BOOLEAN bHandleRelationshipOk;
   
    PATH_TESTED();

    // This intentionally fails!
    PRECONDITION(hParent != OS_INVALID_HANDLE);

    hLock = kmalloc(sizeof(spinlock_t), GFP_KERNEL) ;
    
    if (hLock != NULL)
    {
        PATH_TESTED();
        spin_lock_init(hLock) ;
    }
    else 
    {
        PATH_NOT_YET_TESTED();
        // Error
        hLock = OS_INVALID_HANDLE;
    }

    bHandleRelationshipOk =
            (  ((hLock != OS_INVALID_HANDLE)
             && (hLock != NULL) )   
        ||  (   (OS_INVALID_HANDLE == hLock) ) );
    POSTCONDITION(bHandleRelationshipOk);

    return hLock;
}



/**
 *  Destroy a specified spinlock object.
 * @param A spinlock handle.
 */
void
OsSpinLockDestruct(
    OsSpinLockHandle hLock)
{
    PATH_TESTED();

    PRECONDITION(hLock != OS_INVALID_HANDLE);

    kfree(hLock) ;
}

