/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Tracing related function defintions and macros.
 *
 ***************************************************************************/



#if !defined(EVENT_TRACING)


/**
 *  Trace levels.
 *  These defines are missing in evntrace.h in some DDK build environments (XP).
 */
#if !defined(TRACE_LEVEL_NONE)
  #define TRACE_LEVEL_NONE          0
  #define TRACE_LEVEL_CRITICAL      1
  #define TRACE_LEVEL_FATAL         1
  #define TRACE_LEVEL_ERROR         2
  #define TRACE_LEVEL_WARNING       3
  #define TRACE_LEVEL_INFORMATION   4
  #define TRACE_LEVEL_VERBOSE       5
  #define TRACE_LEVEL_RESERVED6     6
  #define TRACE_LEVEL_RESERVED7     7
  #define TRACE_LEVEL_RESERVED8     8
  #define TRACE_LEVEL_RESERVED9     9
#endif

/**
 *  Trace flags.
 */
#define TRACE_FLAG_INIT             0x00000001
#define TRACE_FLAG_UNINIT           0x00000002
#define TRACE_FLAG_PNP              0x00000004
#define TRACE_FLAG_POWER            0x00000008
#define TRACE_FLAG_WMI              0x00000010
#define TRACE_FLAG_CREATE_CLOSE     0x00000020
#define TRACE_FLAG_IOCTLS           0x00000040
#define TRACE_FLAG_WRITE            0x00000080
#define TRACE_FLAG_READ             0x00000100
#define TRACE_FLAG_DPC              0x00000200
#define TRACE_FLAG_INTERRUPT        0x00000400
#define TRACE_FLAG_LOCKS            0x00000800
#define TRACE_FLAG_QUEUEING         0x00001000
#define TRACE_FLAG_HW_ACCESS        0x00002000
#define TRACE_FLAG_ASSERT           0x00004000
#define TRACE_FLAG_PATH_TRACE       0x00008000
#define TRACE_FLAG_FUNC_TRACE       0x00010000

#define Hexdump(x)                      // Used for HEXDUMP in case tracing is enabled.
#define WPP_INIT_TRACING(pDriverObject, pRegistryPath)
#define WPP_CLEANUP(pDriverObject)


#else



#endif // #if !defined(EVENT_TRACING)
