/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    Definition of GPIO HW registers.
 *
 ***************************************************************************/

#ifndef INC_GpioHwRegDef_h
#define INC_GpioHwRegDef_h



/**
 *  Max number of BARs in this function.
 *  GPIO alone, or GPIO + CONFIG, or GPIO + PMI + CONFIG.
 */
#define GPIO_MAX_NUMBER_OF_BARS                 3


/**
 *  GPIO BAR ID = GPIO class code.
 */
#define GPIO_BAR_ID                             0x08800000


/**
 *  Number of 8-bit locations occupied by the registers.
 */
#define GPIO_REGISTER_SPAN                      1024


/**
 *  I/O and memory space read macros.
 */
#define GPIO_PWM_FREQUENCY                      62500000


/**
 *  GPIO registers.
 */
typedef enum
{
    GPIO_REG_ID                                 = 0x00,
    GPIO_REG_NUMBER_OF_PINS                     = 0x04,
    GPIO_REG_GLOBAL_INTERRUPT_STATUS            = 0x08,     // Read-only.
    GPIO_REG_GLOBAL_INTERRUPT_ENABLE            = 0x0C,
    GPIO_REG_GLOBAL_INTERRUPT_DISABLE           = 0x10,
    GPIO_REG_GLOBAL_WAKEUP_ENABLE               = 0x14,
    GPIO_REG_GLOBAL_WAKEUP_DISABLE              = 0x18,

    GPIO_REG_CONFIG_0                           = 0x0100 + 0x00,
    GPIO_REG_PWM_PRESCALER_0                    = 0x0100 + 0x04,
    GPIO_REG_PWM_PERIOD_0                       = 0x0100 + 0x08,

    GPIO_REG_CONFIG_1                           = 0x0100 + 0x10,
    GPIO_REG_PWM_PRESCALER_1                    = 0x0100 + 0x14,
    GPIO_REG_PWM_PERIOD_1                       = 0x0100 + 0x18,

    GPIO_REG_CONFIG_2                           = 0x0100 + 0x20,
    GPIO_REG_PWM_PRESCALER_2                    = 0x0100 + 0x24,
    GPIO_REG_PWM_PERIOD_2                       = 0x0100 + 0x28,

    GPIO_REG_CONFIG_3                           = 0x0100 + 0x30,
    GPIO_REG_PWM_PRESCALER_3                    = 0x0100 + 0x34,
    GPIO_REG_PWM_PERIOD_3                       = 0x0100 + 0x38,

    GPIO_REG_CONFIG_4                           = 0x0100 + 0x40,
    GPIO_REG_PWM_PRESCALER_4                    = 0x0100 + 0x44,
    GPIO_REG_PWM_PERIOD_4                       = 0x0100 + 0x48,

    GPIO_REG_CONFIG_5                           = 0x0100 + 0x50,
    GPIO_REG_PWM_PRESCALER_5                    = 0x0100 + 0x54,
    GPIO_REG_PWM_PERIOD_5                       = 0x0100 + 0x58,

    GPIO_REG_CONFIG_6                           = 0x0100 + 0x60,
    GPIO_REG_PWM_PRESCALER_6                    = 0x0100 + 0x64,
    GPIO_REG_PWM_PERIOD_6                       = 0x0100 + 0x68,

    GPIO_REG_CONFIG_7                           = 0x0100 + 0x70,
    GPIO_REG_PWM_PRESCALER_7                    = 0x0100 + 0x74,
    GPIO_REG_PWM_PERIOD_7                       = 0x0100 + 0x78,

    GPIO_REG_OUTPUT_VALUE_0_7                   = 0x0100 + 0x80,
    GPIO_REG_INPUT_VALUE_0_7                    = 0x0100 + 0x84,
    GPIO_REG_INTERRUPT_STATUS_0_7               = 0x0100 + 0x90,
    GPIO_REG_INTERRUPT_ENABLE_0_7               = 0x0100 + 0x94,
    GPIO_REG_INTERRUPT_DISABLE_0_7              = 0x0100 + 0x98,


    GPIO_REG_CONFIG_8                           = 0x0200 + 0x00,
    GPIO_REG_PWM_PRESCALER_8                    = 0x0200 + 0x04,
    GPIO_REG_PWM_PERIOD_8                       = 0x0200 + 0x08,

    GPIO_REG_CONFIG_9                           = 0x0200 + 0x10,
    GPIO_REG_PWM_PRESCALER_9                    = 0x0200 + 0x14,
    GPIO_REG_PWM_PERIOD_9                       = 0x0200 + 0x18,

    GPIO_REG_CONFIG_10                          = 0x0200 + 0x20,
    GPIO_REG_PWM_PRESCALER_10                   = 0x0200 + 0x24,
    GPIO_REG_PWM_PERIOD_10                      = 0x0200 + 0x28,

    GPIO_REG_CONFIG_11                          = 0x0200 + 0x30,
    GPIO_REG_PWM_PRESCALER_11                   = 0x0200 + 0x34,
    GPIO_REG_PWM_PERIOD_11                      = 0x0200 + 0x38,

    GPIO_REG_CONFIG_12                          = 0x0200 + 0x40,
    GPIO_REG_PWM_PRESCALER_12                   = 0x0200 + 0x44,
    GPIO_REG_PWM_PERIOD_12                      = 0x0200 + 0x48,

    GPIO_REG_CONFIG_13                          = 0x0200 + 0x50,
    GPIO_REG_PWM_PRESCALER_13                   = 0x0200 + 0x54,
    GPIO_REG_PWM_PERIOD_13                      = 0x0200 + 0x58,

    GPIO_REG_CONFIG_14                          = 0x0200 + 0x60,
    GPIO_REG_PWM_PRESCALER_14                   = 0x0200 + 0x64,
    GPIO_REG_PWM_PERIOD_14                      = 0x0200 + 0x68,

    GPIO_REG_CONFIG_15                          = 0x0200 + 0x70,
    GPIO_REG_PWM_PRESCALER_15                   = 0x0200 + 0x74,
    GPIO_REG_PWM_PERIOD_15                      = 0x0200 + 0x78,

    GPIO_REG_OUTPUT_VALUE_8_15                  = 0x0200 + 0x80,
    GPIO_REG_INPUT_VALUE_8_15                   = 0x0200 + 0x84,
    GPIO_REG_INTERRUPT_STATUS_8_15              = 0x0200 + 0x90,
    GPIO_REG_INTERRUPT_ENABLE_8_15              = 0x0200 + 0x94,
    GPIO_REG_INTERRUPT_DISABLE_8_15             = 0x0200 + 0x98

} GpioRegister;



/**
 *  GPIO CONFIG register definition.
 */
typedef enum
{
    GPIO_REG_CONFIG__PIN_MODE_SHIFT             = 0,
    GPIO_REG_CONFIG__PIN_MODE_MASK              = PIN_MODE_MASK       << GPIO_REG_CONFIG__PIN_MODE_SHIFT,
    GPIO_REG_CONFIG__PIN_MODE_INPUT_VAL         = PIN_MODE_INPUT      << GPIO_REG_CONFIG__PIN_MODE_SHIFT,
    GPIO_REG_CONFIG__PIN_MODE_OUTPUT_VAL        = PIN_MODE_OUTPUT     << GPIO_REG_CONFIG__PIN_MODE_SHIFT,
    GPIO_REG_CONFIG__PIN_MODE_OPEN_DRAIN_VAL    = PIN_MODE_OPEN_DRAIN << GPIO_REG_CONFIG__PIN_MODE_SHIFT,
    GPIO_REG_CONFIG__PIN_MODE_PWM_OUTPUT_VAL    = PIN_MODE_PWM_OUTPUT << GPIO_REG_CONFIG__PIN_MODE_SHIFT,


#if (IW_MODE_RISING_EDGE != 0x00)
#error "Incorrect IW_MODE_RISING_EDGE"
#endif
#if (IW_MODE_FALLING_EDGE != 0x01)
#error "Incorrect IW_MODE_FALLING_EDGE"
#endif
#if (IW_MODE_HIGH_LEVEL != 0x02)
#error "Incorrect IW_MODE_HIGH_LEVEL"
#endif
#if (IW_MODE_LOW_LEVEL != 0x03)
#error "Incorrect IW_MODE_LOW_LEVEL"
#endif
#if (IW_MODE_ANY_EDGE != 0x04)
#error "Incorrect IW_MODE_ANY_EDGE"
#endif
    GPIO_REG_CONFIG__IW_MODE_SHIFT              = 4,
    GPIO_REG_CONFIG__IW_MODE_MASK               = 0x07                 << GPIO_REG_CONFIG__IW_MODE_SHIFT,
    GPIO_REG_CONFIG__IW_MODE_RISING_EDGE_VAL    = IW_MODE_RISING_EDGE  << GPIO_REG_CONFIG__IW_MODE_SHIFT,
    GPIO_REG_CONFIG__IW_MODE_FALLING_EDGE_VAL   = IW_MODE_FALLING_EDGE << GPIO_REG_CONFIG__IW_MODE_SHIFT,
    GPIO_REG_CONFIG__IW_MODE_HIGH_LEVEL_VAL     = IW_MODE_HIGH_LEVEL   << GPIO_REG_CONFIG__IW_MODE_SHIFT,
    GPIO_REG_CONFIG__IW_MODE_LOW_LEVEL_VAL      = IW_MODE_LOW_LEVEL    << GPIO_REG_CONFIG__IW_MODE_SHIFT,
    GPIO_REG_CONFIG__IW_MODE_ANY_EDGE_VAL       = IW_MODE_ANY_EDGE     << GPIO_REG_CONFIG__IW_MODE_SHIFT,

#if (IW_MODE_WAKEUP_ENABLED    != 0x08)
#error "Incorrect IW_MODE_WAKEUP_ENABLED"
#endif
#if (IW_MODE_INTERRUPT_ENABLED != 0x10)
#error "Incorrect IW_MODE_INTERRUPT_ENABLED"
#endif
    GPIO_REG_CONFIG__IW_MODE_ENABLE_SHIFT       = GPIO_REG_CONFIG__IW_MODE_SHIFT,
    GPIO_REG_CONFIG__IW_MODE_ENABLE_MASK        = 0x1F                      << GPIO_REG_CONFIG__IW_MODE_ENABLE_SHIFT,
    GPIO_REG_CONFIG__WAKEUP_ENABLE_BIT          = IW_MODE_WAKEUP_ENABLED    << GPIO_REG_CONFIG__IW_MODE_ENABLE_SHIFT,
    GPIO_REG_CONFIG__INTERRUPT_ENABLE_BIT       = IW_MODE_INTERRUPT_ENABLED << GPIO_REG_CONFIG__IW_MODE_ENABLE_SHIFT,
    GPIO_REG_CONFIG__INTERRUPT_DISABLE_BIT      = BIT(9),
    GPIO_REG_CONFIG__INTERRUPT_STATUS_BIT       = BIT(10),
    GPIO_REG_CONFIG__WAKEUP_STATUS_BIT          = BIT(11),

    GPIO_REG_CONFIG__OUTPUT_VALUE_BIT           = BIT(12),
    GPIO_REG_CONFIG__INPUT_VALUE_BIT            = BIT(13)

} GpioRegConfigDef;



/**
 *  GPIO PWM_PRESCALER register definition.
 */
typedef enum
{
#if (PWM_PRESCALER_MASK != 0x00FF)
#error "Incorrect PWM_PRESCALER_MASK"
#endif
    GPIO_REG_PWM_PRESCALER__SHIFT               = 0,
    GPIO_REG_PWM_PRESCALER__MASK                = PWM_PRESCALER_MASK << GPIO_REG_PWM_PRESCALER__SHIFT,

    GPIO_REG_PWM_PRESCALER__LOG2_FREQ_DIV_16_BIT= BIT(31)

} GpioRegPwmPrescalerDef;



/**
 *  GPIO PWM_PERIOD register definition.
 */
typedef enum
{
#if (PWM_PERIOD_MASK != 0x1FFF)
#error "Incorrect PWM_PERIOD_MASK"
#endif
    GPIO_REG_PWM_PERIOD__HIGH_SHIFT             = 0,
    GPIO_REG_PWM_PERIOD__HIGH_MASK              = PWM_PERIOD_MASK << GPIO_REG_PWM_PERIOD__HIGH_SHIFT,

    GPIO_REG_PWM_PERIOD__LOW_SHIFT              = 16,
    GPIO_REG_PWM_PERIOD__LOW_MASK               = PWM_PERIOD_MASK << GPIO_REG_PWM_PERIOD__LOW_SHIFT,

} GpioRegPwmPeriodDef;



#endif // INC_GpioHwRegDef_h
