/***************************************************************************
 *
 *  Oxford Semiconductor Proprietary and Confidential Information
 *
 *  Copyright:      Oxford Semiconductor Ltd, 2006
 *
 *  Description:    GPIO test code.
 *
 ***************************************************************************/
#ifndef _GPIO_H_
#define _GPIO_H_

/*
 * Macros to help debugging
 */

#undef PDEBUG             /* undef it, just in case */
#ifdef GPIO_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define PDEBUG(fmt, args...) printk( KERN_ALERT "gpio: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...) /* not debugging: nothing */
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...) /* nothing: it's a placeholder */

typedef struct {
    /* Char device structure, this must be first entry in structure */
    struct cdev         cdev;

    // the cdev structure contains a dev_t structure.
    GpioCore *          pGpioCore;
    dev_t               devMajorMinor; // is this used anywhere?

    wait_queue_head_t   wqIoctl;        /* ioctl wait queue */
    OsInterruptStruct   osInterruptStruct;
    struct pci_dev      *pci_dev;
    int                 index;
    struct list_head    gpioDeviceEntry;
    struct kobject      kobj;

} GpioDevice;

#endif /* _GPIO_H_ */
